use strict;
use warnings;

use RT::Test tests => undef;
use HTTP::Status qw();

my $user = RT::Test->load_or_create_user(
    Name            => 'user',
    EmailAddress    => 'user@example.com',
    Privileged      => 1,
    Password        => 'password',
);

ok(
    RT::Test->set_rights(
        { Principal => 'Everyone',  Right => [qw/CreateTicket/] },
        { Principal => 'Requestor', Right => [qw/ShowTicket/] },
    ),
    'set rights'
);

my $secret = "sekrit message";

RT::Test->create_tickets(
    {},
    {
        Subject     => 'ticket A',
        Requestor   => $user->EmailAddress,
        Content     => "user's ticket",
    },
    {
        Subject     => 'ticket B',
        Requestor   => 'root@localhost',
        Content     => $secret,
    },
);

my $ticket_b = RT::Test->last_ticket;

my ($baseurl, $m) = RT::Test->started_ok;
ok $m->login( 'user', 'password' ), 'logged in as user';

$m->get("$baseurl/Ticket/Display.html?id=" . $ticket_b->id);
is($m->status, HTTP::Status::HTTP_FORBIDDEN, 'No permission to view ticket.');
$m->content_contains('No permission');
$m->warning_like(qr/no permission/i, 'no permission warning');

RT::Test->clean_caught_mails;

# Ticket Create is just one example of where this is vulnerable
$m->get_ok('/Ticket/Create.html?Queue=1');
$m->submit_form_ok({
    form_name   => 'TicketCreate',
    fields      => {
        Subject         => 'ticket C',
        AttachTickets   => $ticket_b->id,
    },
}, 'create a ticket');

my @mail = RT::Test->fetch_caught_mails;
ok @mail, "got some outgoing emails";
unlike $mail[0], qr/\Q$secret\E/, "doesn't contain ticket user can't see";

done_testing;

